<?php
require 'vendor/autoload.php'; // Include the necessary libraries, such as phpseclib for RSA signing

use phpseclib3\Crypt\RSA;
use phpseclib3\Crypt\Hash;
use phpseclib3\Crypt\PublicKeyLoader;

function parse_json($prefix, $obj, &$result) {
    if (is_array($obj)) {
        foreach ($obj as $key => $value) {
            $new_prefix = $prefix ? "{$prefix}:{$key}" : $key;
            parse_json($new_prefix, $value, $result);
        }
    } else {
        if ($obj) {
            $result[] = "{$prefix}:{$obj}";
        } else {
            $result[] = "{$prefix}:None";
        }
    }
}

function normalize_message($payload): string
{
    $result = [];
    parse_json('', $payload, $result);
    sort($result);
    return implode(';', $result);
}

function makeRequest(string $sub_merchant_id, string $private_key_path, string $url, array $payload): string {
    $private_key = RSA::load(file_get_contents($private_key_path));
    $public_key = $private_key->getPublicKey();

    $public_key_string = $public_key->toString('PKCS8');

    $public_key_string = str_replace(["\r\n", "\r"], "\n", $public_key_string);


    $api_key = base64_encode($public_key_string);


    $timestamp = time();

    $dumped = json_encode($payload, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);

    $joined_result = normalize_message($payload);

    $base64_encoded_message = base64_encode($joined_result);
    $message = $base64_encoded_message . $timestamp;

    $private_key_openssl = openssl_pkey_get_private(file_get_contents($private_key_path));
    openssl_sign($message, $signature, $private_key_openssl, OPENSSL_ALGO_SHA256);

    $base64_sign = str_replace(
        ['+', '/'],
        ['-', '_'],
        base64_encode($signature)
    );

    $headers = [
        'Content-Type: application/json',
        'X-Access-Token: ' . $api_key,
        'X-Access-Signature: ' . $base64_sign,
        'X-Access-Merchant-Id: ' . $sub_merchant_id,
        'X-Access-Timestamp: ' . $timestamp,
    ];

    $options = [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_POSTFIELDS => $dumped,
    ];

    $curl = curl_init();
    curl_setopt_array($curl, $options);
    $response = curl_exec($curl);
    $status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);

    echo "Response Status Code: " . $status_code;
    return $response;
}


?>